/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.modifiers.fluxed;

import com.xiaoyue.tinkers_ingenuity.content.capability.EnergyCapability;
import com.xiaoyue.tinkers_ingenuity.content.library.tools.TIToolStats;
import com.xiaoyue.tinkers_ingenuity.generic.XIRModifier;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ValidateModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.IToolStat;

public class GenericCapacitor
extends XIRModifier
implements VolatileDataModifierHook,
ValidateModifierHook,
ModifierRemovalHook {
    @Override
    protected void registerHooks(ModuleHookMap.Builder builder) {
        super.registerHooks(builder);
        builder.addHook((Object)this, ModifierHooks.VALIDATE, ModifierHooks.VOLATILE_DATA, ModifierHooks.REMOVE);
    }

    public Component validate(IToolStackView tool, ModifierEntry modifier) {
        int max = tool.getVolatileData().getInt(EnergyCapability.MAX_ENERGY);
        if (tool.getPersistentData().getInt(EnergyCapability.STORED_ENERGY) > max) {
            tool.getPersistentData().putInt(EnergyCapability.STORED_ENERGY, max);
        }
        return null;
    }

    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        if (tool.getVolatileData().getInt(EnergyCapability.MAX_ENERGY) == 0) {
            tool.getPersistentData().remove(EnergyCapability.STORED_ENERGY);
        }
        return null;
    }

    public void addVolatileData(IToolContext context, ModifierEntry modifier, ModDataNBT volatileData) {
        if (volatileData.contains(EnergyCapability.MAX_ENERGY, 3)) {
            volatileData.putInt(EnergyCapability.MAX_ENERGY, volatileData.getInt(EnergyCapability.MAX_ENERGY) + this.getCapacity(context, modifier, volatileData) * modifier.getLevel());
        } else {
            volatileData.putInt(EnergyCapability.MAX_ENERGY, this.getCapacity(context, modifier, volatileData) * modifier.getLevel());
        }
        if (!volatileData.contains(EnergyCapability.ENERGY_OWNER, 8)) {
            volatileData.putString(EnergyCapability.ENERGY_OWNER, this.getId().toString());
        }
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> list, TooltipKey key, TooltipFlag tooltipFlag) {
        if (tool instanceof ToolStack && this.isOwner(tool.getVolatileData())) {
            int energy_store = tool.getStats().getInt((IToolStat)TIToolStats.ENERGY_STORE);
            if (energy_store > 0) {
                list.add((Component)Component.m_237110_((String)"tooltip.tinkers_ingenuity.modifier.stored_energy", (Object[])new Object[]{tool.getPersistentData().getInt(EnergyCapability.STORED_ENERGY), tool.getVolatileData().getInt(EnergyCapability.MAX_ENERGY) + energy_store}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)this.getColor()))));
            } else {
                list.add((Component)Component.m_237110_((String)"tooltip.tinkers_ingenuity.modifier.stored_energy", (Object[])new Object[]{tool.getPersistentData().getInt(EnergyCapability.STORED_ENERGY), tool.getVolatileData().getInt(EnergyCapability.MAX_ENERGY)}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)this.getColor()))));
            }
        }
    }

    public int getCapacity(IToolContext context, ModifierEntry modifier, ModDataNBT volatileData) {
        return 10000;
    }

    public boolean isOwner(IModDataView volatileData) {
        return this.getId().toString().equals(volatileData.getString(EnergyCapability.ENERGY_OWNER));
    }
}

